setDefaultTab("Healing")
UI.Separator()

-- ========================
-- STORAGE
-- ========================
if not storage.swapRing then
  storage.swapRing = {
    mode = "hp",      -- "hp" ou "mp"
    hpPercent = 50,
    mpPercent = 30,
    highRingId = 0,
    lowRingId = 0
  }
end

local config = storage.swapRing

-- ========================
-- UI BUTTON
-- ========================


local ui = setupUI([[
Panel
  height: 19

  Button
    id: setup
    anchors.left: parent.left
    anchors.right: parent.right
    height: 17
    text: Setup Swap Ring
]])
ui:setId("swapRing")

-- ========================
-- SETUP WINDOW
-- ========================
local rootWidget = g_ui.getRootWidget()
local window

if rootWidget then
  window = UI.createWindow("SwapRingWindow", rootWidget)
  window:hide()

  window.closeButton.onClick = function()
    window:hide()
  end


    -- MODE
    local modePanel = window:getChildById('modePanel')
    local hpMode = modePanel:getChildById('hpMode')
    local mpMode = modePanel:getChildById('mpMode')

    local function refreshMode()
    hpMode:setOn(config.mode == "hp")
    mpMode:setOn(config.mode == "mp")
    end

    hpMode.onClick = function()
    config.mode = "hp"
    refreshMode()
    end

    mpMode.onClick = function()
    config.mode = "mp"
    refreshMode()
    end

  refreshMode()

  -- HP SCROLL
  window.hpScroll:setValue(config.hpPercent)
  window.hpText:setText("HP % <= " .. config.hpPercent)

  window.hpScroll.onValueChange = function(_, value)
    config.hpPercent = value
    window.hpText:setText("HP % <= " .. value)
  end

  -- MP SCROLL
  window.mpScroll:setValue(config.mpPercent)
  window.mpText:setText("MP % <= " .. config.mpPercent)

  window.mpScroll.onValueChange = function(_, value)
    config.mpPercent = value
    window.mpText:setText("MP % <= " .. value)
  end

     -- RINGS (busca correta pela hierarquia)
    local ringsPanel = window:getChildById('ringsPanel')

    local highPanel = ringsPanel:getChildren()[1]
    local lowPanel  = ringsPanel:getChildren()[2]

    local highRing = highPanel:getChildById('highRing')
    local lowRing  = lowPanel:getChildById('lowRing')

    highRing.onItemChange = function(widget)
    config.highRingId = widget:getItemId()
    end
    highRing:setItemId(config.highRingId)

    lowRing.onItemChange = function(widget)
    config.lowRingId = widget:getItemId()
    end
    lowRing:setItemId(config.lowRingId)

end

ui.setup.onClick = function()
  window:show()
  window:raise()
  window:focus()
end

-- ========================
-- HELPERS
-- ========================
local function getEquippedRingId()
  local ring = getFinger()
  return ring and ring:getId() or 0
end

local function equipRing(id)
  if id == 0 then return end
  equipItem(id, 8) -- finger
end

-- ========================
-- MAIN MACRO
-- ========================
macro(200, "Swap Ring", function()
  if config.highRingId == 0 or config.lowRingId == 0 then
    return
  end

  local percent
  if config.mode == "hp" then
    percent = hppercent()
    if percent <= config.hpPercent then
      if getEquippedRingId() ~= config.lowRingId then
        equipRing(config.lowRingId)
      end
    else
      if getEquippedRingId() ~= config.highRingId then
        equipRing(config.highRingId)
      end
    end
  else
    percent = manapercent()
    if percent <= config.mpPercent then
      if getEquippedRingId() ~= config.lowRingId then
        equipRing(config.lowRingId)
      end
    else
      if getEquippedRingId() ~= config.highRingId then
        equipRing(config.highRingId)
      end
    end
  end
end)
